#
# standard code to import packages and read data files
#

import pandas as pd
import seaborn as sns
import matplotlib.pyplot as plt
import numpy as np

my_types = {
        'Species' : 'string',
        'Kingdom' : 'string',
        'Class'   : 'string',
        'Assembly status' : 'string',
        'Number of genes' : 'Int64',
        'Number of proteins' : 'Int64'
    }

euk = pd.read_csv(
    "eukaryotes.tsv", 
    sep="\t",
    dtype = my_types,
    na_values=['-']
)

euk_float = euk[euk["Size (Mb)"] < 4_000].dropna()
euk_float["Number of genes"] = euk_float["Number of genes"].astype(float)
euk_float["Number of proteins"] = euk_float["Number of proteins"].astype(float)

weather = pd.read_csv('weather.csv')
con = pd.read_csv("contigs.csv")
london_rain = pd.read_csv("london_rainfall.csv")
names = pd.read_csv("common_names.csv")



#############################################################
#                                                           #   
#           Example code is below this line                 #
#                                                           #
# ############################################################


my_bins = [0, 800, 1200, 1400, 1600]
my_labels = ["<800", "800-1200", "1200-1400", ">1400"]
my_sizes = {"<800": 10, "800-1200": 30, "1200-1400": 60, ">1400": 120}

euk["Size category (Mb)"] = pd.cut(
    euk["Size (Mb)"], bins=my_bins, labels=my_labels
)

sns.relplot(
    data=euk[euk["Class"] == "Birds"].dropna(),
    x="Number of genes",
    y="Number of proteins",
    size="Size category (Mb)",
    sizes=my_sizes,
    aspect=2,
)

plt.title("Number of genes vs. number of proteins for bird genomes")