#
# standard code to import packages and read data files
#

import pandas as pd
import seaborn as sns
import matplotlib.pyplot as plt
import numpy as np

my_types = {
        'Species' : 'string',
        'Kingdom' : 'string',
        'Class'   : 'string',
        'Assembly status' : 'string',
        'Number of genes' : 'Int64',
        'Number of proteins' : 'Int64'
    }

euk = pd.read_csv(
    "eukaryotes.tsv", 
    sep="\t",
    dtype = my_types,
    na_values=['-']
)

euk_float = euk[euk["Size (Mb)"] < 4_000].dropna()
euk_float["Number of genes"] = euk_float["Number of genes"].astype(float)
euk_float["Number of proteins"] = euk_float["Number of proteins"].astype(float)

weather = pd.read_csv('weather.csv')
con = pd.read_csv("contigs.csv")
london_rain = pd.read_csv("london_rainfall.csv")
names = pd.read_csv("common_names.csv")



#############################################################
#                                                           #   
#           Example code is below this line                 #
#                                                           #
# ############################################################


summary["Proportion of genomes"] = (
    summary
    .groupby("Kingdom")
    ["Number of genomes"]
    .transform(lambda x: x / sum(x))
)

g = sns.catplot(
    data=summary,
    x="Size category (Mb)",
    y="Proportion of genomes",
    col="Kingdom",
    kind="bar",
    height=2.5,
    color="grey",
)
g.set_xticklabels(rotation=90)
g.fig.suptitle(
    "Proportion of genomes in each size category for different kingdoms", y=1.1
)