%run -i "standard_header.py"
%matplotlib inline

import matplotlib as mpl

mpl.rcParams["figure.dpi"] = 300

london = weather[weather["City"] == "London"]

dates = (
    london["Day of month"].astype(str)
    + " "
    + london["Month"]
    + " "
    + london["Year"].astype(str)
)
dates.head()

pd.to_datetime(dates).head()

london["date"] = pd.to_datetime(dates)
london.head()

london["date"].dt.dayofweek

(london.groupby(london["date"].dt.dayofweek)["Mean temperature"].mean())

london.groupby(["Year", "Month"])["Mean temperature"].max()

london.resample("2W", on="date")["Mean temperature"].max()

sns.relplot(
    data=london[london["Year"] == 1981],
    x="date",
    y="Mean temperature",
    kind="line",
    ci=None,
    aspect=3,
    height=4,
)

plt.title("Mean daily temperature for each day in London in 1981")

london.rolling("14D", on="date")["Mean temperature"].mean()

london["rolling_mean"] = london.rolling("14D", on="date")[
    "Mean temperature"
].mean()
sns.relplot(
    data=london[london["Year"] == 1981],
    x="date",
    y="rolling_mean",
    kind="line",
    ci=None,
    aspect=3,
    height=4,
)

plt.title("14 day rolling mean temperature for London in 1981")

weather["Year"].head()

weather.Year.head()

weather[weather["City"] == "Berlin"]["Mean temperature"]

weather.loc[weather["City"] == "Berlin", "Mean temperature"]

weather.query('City == "Berlin"').head()

# pandas_plot.py

(
    weather[(weather["City"] == "Edinburgh") & (weather["Year"] == 1990)]
    .set_index("Day of year")["Mean temperature"]
    .plot()
)

plt.title("Mean daily temperature in Edinburgh in 1990")

year_summary = (
    weather[weather["Year"] == 1990]
    .groupby(["Day of year", "City"])["Mean temperature"]
    .mean()
    .unstack()
)

year_summary.head()

year_summary.plot()
plt.title("Mean daily temperature in three cities in 1990")

sns.relplot(
    data=weather,
    x="Day of year",
    y="Mean temperature",
    hue="City",
    kind="line",
    ci=None,
    aspect=3,
    height=3,
)

plt.title("Mean daily temperature in three cities in 1990")