#
# standard code to import packages and read data files
#

import pandas as pd
import seaborn as sns
import matplotlib.pyplot as plt
import numpy as np

my_types = {
        'Species' : 'string',
        'Kingdom' : 'string',
        'Class'   : 'string',
        'Assembly status' : 'string',
        'Number of genes' : 'Int64',
        'Number of proteins' : 'Int64'
    }

euk = pd.read_csv(
    "eukaryotes.tsv", 
    sep="\t",
    dtype = my_types,
    na_values=['-']
)

euk_float = euk[euk["Size (Mb)"] < 4_000].dropna()
euk_float["Number of genes"] = euk_float["Number of genes"].astype(float)
euk_float["Number of proteins"] = euk_float["Number of proteins"].astype(float)

weather = pd.read_csv('weather.csv')
con = pd.read_csv("contigs.csv")
london_rain = pd.read_csv("london_rainfall.csv")
names = pd.read_csv("common_names.csv")



#############################################################
#                                                           #   
#           Example code is below this line                 #
#                                                           #
# ############################################################


sns.relplot(
    data=animals, x="Number of genes", y="Number of proteins", height=6
)
plt.title("Number of genes vs number of proteins\n for animal genomes")
plt.xlabel("Number of predicted genes")
plt.ylabel("Number of predicted proteins")