#
# standard code to import packages and read data files
#

import pandas as pd
import seaborn as sns
import matplotlib.pyplot as plt
import numpy as np

my_types = {
        'Species' : 'string',
        'Kingdom' : 'string',
        'Class'   : 'string',
        'Assembly status' : 'string',
        'Number of genes' : 'Int64',
        'Number of proteins' : 'Int64'
    }

euk = pd.read_csv(
    "eukaryotes.tsv", 
    sep="\t",
    dtype = my_types,
    na_values=['-']
)

euk_float = euk[euk["Size (Mb)"] < 4_000].dropna()
euk_float["Number of genes"] = euk_float["Number of genes"].astype(float)
euk_float["Number of proteins"] = euk_float["Number of proteins"].astype(float)

weather = pd.read_csv('weather.csv')
con = pd.read_csv("contigs.csv")
london_rain = pd.read_csv("london_rainfall.csv")
names = pd.read_csv("common_names.csv")



#############################################################
#                                                           #   
#           Example code is below this line                 #
#                                                           #
# ############################################################


month_counts = {}

for chunk in pd.read_csv("all_weather.csv", chunksize=10000):
    chunk_rainy_days = chunk[chunk["Rainfall (mm)"] > 100]
    for month, count in (
        chunk_rainy_days["Month"].value_counts().to_dict().items()
    ):

        # look up the current count for the month, with default
        # of zero in case it's the first time we've seen this month
        current_month_count = month_counts.get(month, 0)

        # store the updated count, which is the current count
        # plus the count for this chunk
        month_counts[month] = current_month_count + count
month_counts