#
# standard code to import packages and read data files
#

import pandas as pd
import seaborn as sns
import matplotlib.pyplot as plt
import numpy as np

my_types = {
        'Species' : 'string',
        'Kingdom' : 'string',
        'Class'   : 'string',
        'Assembly status' : 'string',
        'Number of genes' : 'Int64',
        'Number of proteins' : 'Int64'
    }

euk = pd.read_csv(
    "eukaryotes.tsv", 
    sep="\t",
    dtype = my_types,
    na_values=['-']
)

euk_float = euk[euk["Size (Mb)"] < 4_000].dropna()
euk_float["Number of genes"] = euk_float["Number of genes"].astype(float)
euk_float["Number of proteins"] = euk_float["Number of proteins"].astype(float)

weather = pd.read_csv('weather.csv')
con = pd.read_csv("contigs.csv")
london_rain = pd.read_csv("london_rainfall.csv")
names = pd.read_csv("common_names.csv")



#############################################################
#                                                           #   
#           Example code is below this line                 #
#                                                           #
# ############################################################


data = euk[
    (euk["Kingdom"] == "Fungi") & (euk["Publication year"].between(2010, 2017))
]

g = sns.FacetGrid(
    data=data,
    hue="Class",
    col="Publication year",
    col_wrap=4,
    aspect=1,
    height=3,
    palette="Set2",
)

g.map_dataframe(draw_distribution)
g.set_axis_labels("GC%")
g.add_legend()
g.fig.suptitle(
    "Distribution of GC percentage for fungal genomes in different classes\nfor years between 2010 and 2017",
    y=1.1,
)