#
# standard code to import packages and read data files
#

import pandas as pd
import seaborn as sns
import matplotlib.pyplot as plt
import numpy as np

my_types = {
        'Species' : 'string',
        'Kingdom' : 'string',
        'Class'   : 'string',
        'Assembly status' : 'string',
        'Number of genes' : 'Int64',
        'Number of proteins' : 'Int64'
    }

euk = pd.read_csv(
    "eukaryotes.tsv", 
    sep="\t",
    dtype = my_types,
    na_values=['-']
)

euk_float = euk[euk["Size (Mb)"] < 4_000].dropna()
euk_float["Number of genes"] = euk_float["Number of genes"].astype(float)
euk_float["Number of proteins"] = euk_float["Number of proteins"].astype(float)

weather = pd.read_csv('weather.csv')
con = pd.read_csv("contigs.csv")
london_rain = pd.read_csv("london_rainfall.csv")
names = pd.read_csv("common_names.csv")



#############################################################
#                                                           #   
#           Example code is below this line                 #
#                                                           #
# ############################################################


g = sns.FacetGrid(weather, col="Month", col_wrap=4, aspect=2, height=1.5)

cbar_ax = g.fig.add_axes(
    [
        1.05,  # distance from the left of the figure
        0.2,  # distance from the bottom of the figure
        0.02,  # width of the axis
        0.6,
    ]  # height of the axis
)

g.map_dataframe(
    plot_temperature,
    vmin=weather["Temperature (°C)"].min(),
    vmax=weather["Temperature (°C)"].max(),
    cbar_axis=cbar_ax,
)

g.fig.suptitle(
    "Mean daily temperature in three cities between 1960 and 2017", y=1.1
)
g.fig.suptitle("Mean monthly temperature for three cities by year", y=1.05)